*
* Example of unconditional simulation
*
open data nile.dat
calendar 1871
data(format=free,org=columns,skips=1) 1871:1 1970:1 nile
*
* Kalman filter through the data period
*
dlm(a=1.0,c=1.0,sv=15099.0,sw=1469.1,presample=diffuse,y=nile,$
  type=filter) / xstates vstates
*
* Simulate 10000 realizations from the end of the data, keeping track of
* the maximum flow for each.
*
compute ndraws=10000
set maxflow 1 ndraws = 0.0
do reps=1,ndraws
  dlm(a=1.0,c=1.0,sv=15099.0,sw=1469.1,$
    x0=xstates(1970:1),sx0=vstates(1970:1),$
    type=simulate,yhat=yhat) 1971:1 2020:1 xstates
  set simflow 1971:1 2020:1 = %scalar(yhat)
  ext(noprint) simflow
  compute maxflow(reps)=%maximum
end do reps
*
* Compute the percentiles of the simulated maximum flows.
*
stats(fractiles,nomoments) maxflow

